<?php

/** ------------------------------------------------------------------------
* This file has been created by Gloubi Boulga Generator in order to help
* you understanding the Glb architecture implementation.
* This must be used to create your plugin Admin Page
----------------------------------------------------------------------- */

?>

<div class="wrap">

    <h1><?= __glb('Admin %s', '{{generator_sname}}') ?></h1>

    <?php

    // get current tab
    $current_tab = $this->request->get_get('tab', '{{generator_sname_lc_d}}');

    // build activity admin table, filtering items for this plugin
    if ($current_tab == 'activity') {

        // display columns
        $columns = array( 'date' => __glb('Date'), 'action' => __glb('Action')<<GENERATOR_DATABASE, '{{generator_main_use_sing_lc_u}}' => __glb('{{generator_main_use_sing_fwc_u}}')GENERATOR_DATABASE>>, 'message' => __glb('Message'), 'user_description' => __glb('User') );
        // sortable columns
        $sortable_columns = array( 'date' => array('date', true) );
        // searchable columns
        $searchable_columns = array( 'message', 'message_args', 'user_description' );

        // load data for filters
        $actions = $this->database->select_distinct('glb_core_logs', 'action', 'plugin_key = %s', [$this->key]);
        <<GENERATOR_DATABASE$data = (new Glb_Db_Collection('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}'))->load();GENERATOR_DATABASE>>
        $filters = [
            'user_id' => ['label' => 'All users', 'values' => Glb_Users::extract_users_attr('user_nicename'), 'type' => '%d'] ,
            'action' => ['label' => 'All actions', 'values' => Glb_Array::convert_associative($actions), 'type' => '%s', 'attrs' => ['data-multiple' => true, 'data-placeholder' => __glb("All actions")]],
            <<GENERATOR_DATABASE'element_id' => ['label' => 'All {{generator_main_use_plur_lc_sp}}', 'values' => Glb_Array::combine($data, 'id', 'name'), 'type' => '%d', 'attrs' => ['data-multiple' => true, 'data-placeholder' => __glb("All")]]GENERATOR_DATABASE>>
        ];

        // retrieve paging infos
        $paging = $this->request->get_paging('glb_{{generator_sname_lc_u}}_activity_page:table', $sortable_columns);

        // the activity class, Glb_Admin_Table is an extension of WP_List_Table
        class Glb_{{generator_sname_wc_u}}_Activity_Admin_Table extends Glb_Admin_Table {
            <<GENERATOR_DATABASEpublic function column_{{generator_main_use_sing_lc_u}}($item) {
                $current = Glb_Db::instance()->select_val('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', 'name', 'id = %d', [$item->element_id]);
                if (empty($current)) {
                    if ($item->element_type == '{{generator_main_use_sing_lc_u}}') {
                        return '[' . __glb('deleted') . ']';
                    } else {
                        return '-';
                    }
                } else {
                    return glb_esch($this->format_text('{{generator_main_use_sing_lc_u}}', $current));
                }
            }GENERATOR_DATABASE>>
        };

        // the activity class instance
        $activity_table = new Glb_{{generator_sname_wc_u}}_Activity_Admin_Table ( $columns, $sortable_columns, $paging['per_page'], $filters, $searchable_columns);

        // get applied filters and interpret them as WHERE
        $applied_conditions = $activity_table->get_applied_where('all');

        // build where
        $where = 'plugin_key = %s' . (empty($applied_conditions['where']) ? '' : ' AND ' . $applied_conditions['where']);
        $where_values = array_merge(array('gloubi-boulga-{{generator_sname_lc_d}}'), $applied_conditions['where_values']);

        // get total items count
        $total_items = $this->database->select_count('glb_core_logs', 'id', $where, $where_values);
        if ($total_items < $paging['paged']) {
            $paging['paged'] = 0;
        }

        // finalize $where_values
        $where_values[] = $paging['per_page'];
        $where_values[] = $paging['paged'];

        // load items
        $logs = new Glb_Db_Collection('glb_core_logs');

        // checks for sql injection
        $this->database->check_order_by('glb_core_logs', $paging['order_col']);
        $this->database->check_order_directions($paging['order_dir']);

        // load data
        $logs->load($where . ' ORDER BY ' . $paging['order_col'] . ' ' . $paging['order_dir'] . ' LIMIT %d OFFSET %d', $where_values);

        // set data to table instance
        $activity_table->set_items($logs, $total_items);

        // prepare_items need to be called, as specified by WP_List_Table
        $activity_table->prepare_items();

    }

    <<GENERATOR_DATABASE
    else if ($current_tab == '{{generator_main_use_plur_lc_u}}' ) {

        // display columns
        $columns = array( 'name' => __glb('Name'), 'status' => __glb('Enabled'), 'created' => __glb('Date'), 'description' => __glb('Description') );
        // sortable columns
        $sortable_columns = array( 'created' => array('created', true), 'name' =>  array('name', true), 'status' =>  array('status', true));

        $filters = [
            'status' => ['label' => __glb('All statuses'), 'values' => [0 => __glb('Disabled'), 1 => __glb('Enabled')], 'type' => '%d'] ,
        ];

        $paging = $this->request->get_paging('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}_page:table', $sortable_columns);

        // ze table class instance
        $ze_table = new Glb_Admin_Table ( $columns, $sortable_columns, $paging['per_page'], $filters );

        // declare ze table actions on 'name' field
        $ze_table->set_actions (
            array('name' =>
                array (
                    'edit' => array(
                        'behavior' => 'glb-ajax',
                        'url' => admin_url('admin-ajax.php'),
                        'params' => array('action' => '{{generator_sname_lc_u}}_admin_service',
                            'method' => 'edit',
                            'id' => '{{id}}',
                            'glb_nonce' => (function($item) {
                                return $this->request->create_nonce('glb-{{generator_sname_lc_d}}-edit-' . $item['id']);
                            }),),
                    ),
                    'delete' => array(
                        'behavior' => 'glb-ajax',
                        'url' => admin_url('admin-ajax.php'),
                        'params' => array(
                            'action' => '{{generator_sname_lc_u}}_admin_service',
                            'method' => 'delete',
                            'id' => '{{id}}',
                            'glb_nonce' => function($item) {
                                return $this->request->create_nonce('glb-{{generator_sname_lc_d}}-delete-' . $item['id']);
                            },
                        ),
                        'confirm' => array(
                            'title' => array(__glb('Delete « %s » ?', '{{name}}')),
                            'content' => array(__glb('Warning ! This will finally delete this {{generator_main_use_sing_fwc_u}} ! Are you crazy enough to do that ?!'))
                        )
                    ),
                )
            )
        );

        // if something has been modified before, then it will be highlighted
        $ze_table->set_highlights(Glb_Session::instance()->pop('{{generator_sname_lc_u}}.highlights.{{generator_main_use_plur_lc_u}}'));

        // get applied filters and interpret them as WHERE
        $applied_conditions = $ze_table->get_applied_where('filters');
        $where = $applied_conditions['where'];
        $where_values = $applied_conditions['where_values'];

        // get total items count
        $total_items = $this->database->select_count('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', 'id');

        if ($total_items < $paging['paged']) {
            $paging['paged'] = 0;
        }

        $where_values[] = $paging['per_page'];
        $where_values[] = $paging['paged'];

        // load items
        $items = new Glb_Db_Collection('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}');

        // checks to avoid sql injections
        $this->database->check_order_by('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', $paging['order_col']);
        $this->database->check_order_directions($paging['order_dir']);

        $items->load($where . ' ORDER BY ' . $paging['order_col'] . ' ' . $paging['order_dir'] . ' LIMIT %d OFFSET %d', $where_values);
        $ze_table->set_items($items, $total_items);

        // prepare_items need to be called, as specified by WP_List_Table
        $ze_table->prepare_items();

    }
    GENERATOR_DATABASE>>

    ?>

    <div id="icon-themes" class="icon32"></div>
    <?php settings_errors(); ?>


    <h2 class="nav-tab-wrapper">
        <a href="admin.php?page=glb_{{generator_sname_lc_u}}_admin_page&tab={{generator_sname_lc_u}}" class="nav-tab<?= ($current_tab == '{{generator_sname_lc_u}}' ? ' nav-tab-active' : '') ?>"><?=__glb('{{generator_sname_fwc_s}}')?></a>
        <a href="admin.php?page=glb_{{generator_sname_lc_u}}_admin_page&tab=activity" class="nav-tab<?= ($current_tab == 'activity' ? ' nav-tab-active' : '') ?>"><?=__glb('Activity')?></a>
        <<GENERATOR_DATABASE
        <a href="admin.php?page=glb_{{generator_sname_lc_u}}_admin_page&tab={{generator_main_use_plur_lc_u}}" class="nav-tab<?= ($current_tab == '{{generator_main_use_plur_lc_u}}' ? ' nav-tab-active' : '') ?>"><?=__glb('{{generator_main_use_plur_fwc_u}}')?></a>
        GENERATOR_DATABASE>>
        <a href="admin.php?page=glb_{{generator_sname_lc_u}}_admin_page&tab=settings" class="nav-tab<?= ($current_tab == 'settings' ? ' nav-tab-active' : '') ?>"><?=__glb('Settings')?></a>
    </h2>

    <form method="POST">

        <?php
        if ($current_tab == 'settings') {
            // the settings tab
            echo '<input type="hidden" name="glb_nonce" value="' . $this->request->create_nonce('glb-{{generator_sname_lc_u}}-settings-edit') . '">';
            $this->render_template('core:elements/glb-core-admin-settings-table');
            submit_button(__glb('Save changes'), 'primary', 'glb_{{generator_sname_lc_u}}_settings_submit');

        } else if ($current_tab == 'activity') {

            // the activity tab
            $activity_table->display();

        <<GENERATOR_DATABASE
        } else if ($current_tab == '{{generator_main_use_plur_lc_u}}') {

            $add_new_link = [ 'url' => admin_url('admin-ajax.php'), 'text' => __glb('Add new')];
            echo '<h1 class="wp-heading-inline">' . __glb('{{generator_main_use_plur_fwc_u}}') . '</h1>' .
                Glb_Html::get('link')->html($add_new_link, [
                    'class' => 'page-title-action',
                    'data-glb-behavior' => 'glb-ajax',
                    'data-glb-behavior-args' => base64_encode(wp_json_encode([
                            "action" => "{{generator_sname_lc_u}}_admin_service",
                            "method" => "edit",
                            "id" => "~new",
                            "glb_nonce" => $this->request->create_nonce('glb-{{generator_sname_lc_u}}-edit-~new')
                    ]))
                ]) . '<hr class="wp-header-end">';

            $ze_table->display();
        GENERATOR_DATABASE>>
        } else if ($current_tab == '{{generator_sname_lc_u}}') {

            Glb_Template::get('elements/glb-{{generator_sname_lc_u}}-shortcode')->render();

        }
        ?>

    </form>

</div>